import {createAction} from 'typesafe-actions';

import {
    IAviaDynamicActionLogParamsClient,
    IAviaSearchActionLogParamsClient,
} from 'server/loggers/avia/AviaActionLog/types/IAviaActionLogParamsClient';
import {IAviaSearchShowLogParamsClient} from 'server/loggers/avia/AviaShowLog/types/IAviaShowLogParamsClient';
import {EAviaActionLogActionName} from 'server/loggers/avia/AviaActionLog/types/EAviaActionLogActionName';
import EAviaDynamicActionLogActionName from 'server/loggers/avia/AviaActionLog/types/EAviaDynamicActionLogActionName';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';
import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';

export const loggerActions = {
    moveToOrder: createAction('avia/aviaLogging/search/MOVE_TO_ORDER')(),
    logSearchAction: createAction(`avia/aviaLogging/search/LOG_ACTION`)<{
        name: EAviaActionLogActionName;
        params?: Partial<IAviaSearchActionLogParamsClient>;
    }>(),
    logSearchShow: createAction(
        `avia/aviaLogging/search/LOG_SHOW`,
    )<IAviaSearchShowLogParamsClient>(),
    logDynamicAction: createAction(`avia/aviaLogging/dynamic/LOG_ACTION`)<{
        name: EAviaDynamicActionLogActionName;
        params?: Partial<IAviaDynamicActionLogParamsClient>;
    }>(),
    offerBaggageFilter: createAction(
        'avia/aviaLogging/search/OFFER_BAGGAGE_FILTER',
    )<{
        group: IAviaVariantGroup;
        variant: IResultAviaVariant | null;
        position: number;
        interesting: boolean;
    }>(),
};
