import {createAsyncAction, createAction} from 'typesafe-actions';

import EAviaDynamicTypeView from 'types/avia/priceIndex/EAviaDynamicTypeView';
import TValidDataForRequestDynamic from 'types/avia/dynamic/TValidDataForRequestDynamic';

import {
    IDynamicsDay,
    TDynamicsDaysInfo,
} from '../utils/convertPriceIndexDataToDynamicsData';

const {
    request: dynamicsSearchRequest,
    success: dynamicsSearchSuccess,
    failure: dynamicsSearchFailure,
} = createAsyncAction(
    'avia/aviaPriceIndex/dynamics/SEARCH_REQUEST',
    'avia/aviaPriceIndex/dynamics/SEARCH_SUCCESS',
    'avia/aviaPriceIndex/dynamics/SEARCH_FAILURE',
)<
    TValidDataForRequestDynamic,
    {data: TDynamicsDaysInfo} & TValidDataForRequestDynamic,
    {error: string} & TValidDataForRequestDynamic
>();

const {
    request: inlineSearchRequest,
    success: inlineSearchSuccess,
    failure: inlineSearchFailure,
} = createAsyncAction(
    'avia/aviaPriceIndex/dynamics/INLINE_SEARCH_REQUEST',
    'avia/aviaPriceIndex/dynamics/INLINE_SEARCH_SUCCESS',
    'avia/aviaPriceIndex/dynamics/INLINE_SEARCH_FAILURE',
)<
    TValidDataForRequestDynamic,
    {data: IDynamicsDay} & TValidDataForRequestDynamic,
    {error: string} & TValidDataForRequestDynamic
>();

const inlineSearchPriceFounded = createAction(
    'avia/aviaPriceIndex/dynamics/INLINE_SEARCH_PRICE_FOUNDED',
)<{data: IDynamicsDay} & TValidDataForRequestDynamic>();

const updatePrices = createAction('avia/aviaPriceIndex/dynamics/UPDATE_PRICES')<
    {data: TDynamicsDaysInfo} & TValidDataForRequestDynamic
>();

const changeBackwardDate = createAction(
    'avia/aviaPriceIndex/dynamics/SEARCH_BACKWARD_DATE_CHANGED',
)<string>();

const setWasOpened = createAction(
    'avia/aviaPriceIndex/dynamics/SET_WAS_OPENED',
)<boolean>();

const setTypeView = createAction(
    'avia/aviaPriceIndex/dynamics/SET_TYPE_VIEW',
)<EAviaDynamicTypeView>();

export {
    dynamicsSearchRequest,
    dynamicsSearchSuccess,
    dynamicsSearchFailure,
    inlineSearchRequest,
    inlineSearchSuccess,
    inlineSearchFailure,
    inlineSearchPriceFounded,
    changeBackwardDate,
    updatePrices,
    setWasOpened,
    setTypeView,
};
