import TValidDataForRequestDynamic from 'types/avia/dynamic/TValidDataForRequestDynamic';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import * as actions from 'reducers/avia/aviaPriceIndex/dynamics/actions';
import {convertPriceIndexDataToDynamicsData} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import aviaDynamicsPricesCurrentRequestParamsSelector from 'selectors/avia/dynamicsPrices/aviaDynamicsPricesCurrentRequestParamsSelector';

import isCompatibleDynamicSearch from 'projects/avia/lib/dynamic/isCompatibleDynamicSearch';

import {aviaPriceIndexBrowserProvider} from 'serviceProvider/avia/aviaPriceIndexBrowserProvider';

/**
 * Производит запрос за дополнительными данными динамики цен.
 * То есть применятся для обновления/добавления данных в фоне для текущего состояния фильтров
 * и поисковой формы динамики.
 *
 * Применяется, например, для расширения интервала дат для динамики цен в десктопе.
 *
 * Не меняет состояние запроса в сторе (свойство status: EAsyncStatus) - то есть не
 * будет менять его на "loading" или "error".
 */
export default function additionalDynamicRequest(
    dataForRequest: TValidDataForRequestDynamic,
): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        const {searchForm, filters, interval} = dataForRequest;

        try {
            const result = await aviaPriceIndexBrowserProvider.dynamics(
                interval,
                searchForm,
                filters,
            );

            const actualState = getState();
            const currentDynamicsPricesRequestParams =
                aviaDynamicsPricesCurrentRequestParamsSelector(actualState);

            if (!currentDynamicsPricesRequestParams) {
                return;
            }

            if (
                isCompatibleDynamicSearch(
                    currentDynamicsPricesRequestParams,
                    dataForRequest,
                )
            ) {
                dispatch(
                    actions.dynamicsSearchSuccess({
                        data: convertPriceIndexDataToDynamicsData(result),
                        ...dataForRequest,
                    }),
                );
            }
        } catch (e) {
            console.log(e);
        }
    };
}
