import {createAsyncAction, createAction} from 'typesafe-actions';

import TValidDataForRequestTableDynamic from 'types/avia/dynamic/TValidDataForRequestTableDynamic';
import TValidDataForRequestDynamic from 'types/avia/dynamic/TValidDataForRequestDynamic';

import {
    IDynamicsDay,
    TDynamicTableDaysInfo,
} from '../utils/convertPriceIndexDataToDynamicsData';

const {
    request: dynamicsSearchRequest,
    success: dynamicsSearchSuccess,
    failure: dynamicsSearchFailure,
} = createAsyncAction(
    'avia/aviaPriceIndex/dynamicsTable/SEARCH_REQUEST',
    'avia/aviaPriceIndex/dynamicsTable/SEARCH_SUCCESS',
    'avia/aviaPriceIndex/dynamicsTable/SEARCH_FAILURE',
)<
    TValidDataForRequestTableDynamic,
    {data: TDynamicTableDaysInfo} & TValidDataForRequestTableDynamic,
    {error: string} & TValidDataForRequestTableDynamic
>();

const {
    request: inlineSearchRequest,
    success: inlineSearchSuccess,
    failure: inlineSearchFailure,
} = createAsyncAction(
    'avia/aviaPriceIndex/dynamicsTable/INLINE_SEARCH_REQUEST',
    'avia/aviaPriceIndex/dynamicsTable/INLINE_SEARCH_SUCCESS',
    'avia/aviaPriceIndex/dynamicsTable/INLINE_SEARCH_FAILURE',
)<
    TValidDataForRequestDynamic,
    {data: IDynamicsDay} & TValidDataForRequestDynamic,
    {error: string} & TValidDataForRequestDynamic
>();

const inlineSearchPriceFounded = createAction(
    'avia/aviaPriceIndex/dynamicsTable/INLINE_SEARCH_PRICE_FOUNDED',
)<{data: IDynamicsDay} & TValidDataForRequestDynamic>();

const updatePrices = createAction(
    'avia/aviaPriceIndex/dynamicsTable/UPDATE_PRICES',
)<{data: TDynamicTableDaysInfo} & TValidDataForRequestTableDynamic>();

export {
    dynamicsSearchRequest,
    dynamicsSearchSuccess,
    dynamicsSearchFailure,
    inlineSearchRequest,
    inlineSearchSuccess,
    inlineSearchFailure,
    inlineSearchPriceFounded,
    updatePrices,
};
