import {EDynamicsDayStatus} from 'projects/avia/components/Dynamics/types/IDynamicsDay';

import IPrice from 'utilities/currency/PriceInterface';

import {IDynamicsDay} from './convertPriceIndexDataToDynamicsData';

/**
 * Конвертирует данные, полученные от инлайн-поисков в формат дня с ценой динамики и недельных цен
 */
export function convertInlineSearchDataToDynamicsDay(
    price: Nullable<IPrice>,
    progress: number,
    searchInProgress?: boolean,
): IDynamicsDay {
    let status;

    if (searchInProgress) {
        status = EDynamicsDayStatus.SEARCHING;
    } else {
        status = price
            ? EDynamicsDayStatus.HAS_DATA
            : EDynamicsDayStatus.NO_DATA;
    }

    return {
        progress,
        status,
        fromSearch: true,
        price: price
            ? {
                  ...price,
                  roughly: Boolean(searchInProgress),
              }
            : null,
    };
}
