import {IDataForRequestDynamic} from 'types/avia/dynamic/IDataForRequestDynamic';
import {EDynamicsDayStatus} from 'projects/avia/components/Dynamics/types/IDynamicsDay';

import {IAviaDynamicsState} from 'reducers/avia/aviaPriceIndex/dynamics/reducer';
import {IAviaWeekPricesState} from 'reducers/avia/aviaPriceIndex/weekPrices/reducer';

import {PayloadAction} from 'typesafe-actions/dist/type-helpers';

export default function dynamicInlineSearchFailureHandler<
    State extends IAviaDynamicsState | IAviaWeekPricesState,
>(
    state: State,
    {payload}: PayloadAction<any, {error: string} & IDataForRequestDynamic>,
): State {
    const {
        searchForm: {when},
    } = payload;

    return {
        ...state,
        prices: {
            ...state.prices,
            [when]: {
                ...state.prices?.[when],
                status: EDynamicsDayStatus.WAS_ERROR,
                fromSearch: false,
            },
        },
    };
}
