import {IDataForRequestDynamic} from 'types/avia/dynamic/IDataForRequestDynamic';

import {IAviaDynamicsState} from 'reducers/avia/aviaPriceIndex/dynamics/reducer';
import {IAviaWeekPricesState} from 'reducers/avia/aviaPriceIndex/weekPrices/reducer';
import {IDynamicsDay} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import {PayloadAction} from 'typesafe-actions/dist/type-helpers';

export default function dynamicInlineSearchPriceFoundedHandler<
    State extends IAviaDynamicsState | IAviaWeekPricesState,
>(
    state: State,
    {
        payload,
    }: PayloadAction<any, {data: IDynamicsDay} & IDataForRequestDynamic>,
): State {
    const {
        data,
        searchForm: {when},
    } = payload;

    return {
        ...state,
        prices: {
            ...state.prices,
            [when]: {
                ...data,
                fromSearch: true,
            },
        },
    };
}
