import {IDataForRequestDynamic} from 'types/avia/dynamic/IDataForRequestDynamic';
import EAsyncStatus from 'types/common/EAsyncStatus';

import {IAviaDynamicsState} from 'reducers/avia/aviaPriceIndex/dynamics/reducer';
import {IAviaWeekPricesState} from 'reducers/avia/aviaPriceIndex/weekPrices/reducer';

import {PayloadAction} from 'typesafe-actions/dist/type-helpers';

export default function dynamicSearchFailureHandler<
    State extends IAviaDynamicsState | IAviaWeekPricesState,
>(
    state: State,
    {payload}: PayloadAction<any, {error: string} & IDataForRequestDynamic>,
): State {
    return {
        ...state,
        status: EAsyncStatus.ERROR,
        error: payload.error,
        prices: null,
        forSearchForm: payload.searchForm,
        forFilters: payload.filters,
        forInterval: payload.interval,
    };
}
