import {IDataForRequestDynamic} from 'types/avia/dynamic/IDataForRequestDynamic';
import EAsyncStatus from 'types/common/EAsyncStatus';

import {IAviaDynamicsState} from 'reducers/avia/aviaPriceIndex/dynamics/reducer';
import {IAviaWeekPricesState} from 'reducers/avia/aviaPriceIndex/weekPrices/reducer';
import {TDynamicsDaysInfo} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import {PayloadAction} from 'typesafe-actions/dist/type-helpers';

export default function dynamicSearchSuccessHandler<
    State extends IAviaDynamicsState | IAviaWeekPricesState,
>(
    state: State,
    {
        payload,
    }: PayloadAction<any, {data: TDynamicsDaysInfo} & IDataForRequestDynamic>,
): State {
    return {
        ...state,
        status: EAsyncStatus.SUCCESS,
        error: null,
        prices: payload.data,
        forSearchForm: payload.searchForm,
        forFilters: payload.filters,
        forInterval: payload.interval,
    };
}
