import {IDataForRequestDynamic} from 'types/avia/dynamic/IDataForRequestDynamic';
import EAsyncStatus from 'types/common/EAsyncStatus';

import {IAviaDynamicsState} from 'reducers/avia/aviaPriceIndex/dynamics/reducer';
import {IAviaWeekPricesState} from 'reducers/avia/aviaPriceIndex/weekPrices/reducer';
import {TDynamicsDaysInfo} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import {PayloadAction} from 'typesafe-actions/dist/type-helpers';
import isCompatibleDynamicSearch from 'projects/avia/lib/dynamic/isCompatibleDynamicSearch';

export default function dynamicUpdatePrices<
    State extends IAviaDynamicsState | IAviaWeekPricesState,
>(
    state: State,
    {
        payload,
    }: PayloadAction<any, {data: TDynamicsDaysInfo} & IDataForRequestDynamic>,
): State {
    const {forSearchForm, forFilters, forInterval, prices} = state;

    if (forSearchForm && forFilters && forInterval) {
        // Обновление цен
        if (
            !isCompatibleDynamicSearch(payload, {
                searchForm: forSearchForm,
                filters: forFilters,
                interval: forInterval,
            })
        ) {
            return state;
        }

        if (!prices) {
            return {
                ...state,
                prices: payload.data,
            };
        }

        // Обновляем только те цены, которых нет совсем или они не получены через поиск или inline-поиск
        const newPrices = Object.entries(
            payload.data,
        ).reduce<TDynamicsDaysInfo>((priceForUpdate, [key, price]) => {
            const existPrice = prices[key];

            if (!existPrice || !existPrice.fromSearch) {
                priceForUpdate[key] = price;
            }

            return priceForUpdate;
        }, {});

        return {
            ...state,
            prices: {
                ...prices,
                ...newPrices,
            },
        };
    }

    // По сути это назначение цен
    return {
        ...state,
        prices: payload.data,
        status: EAsyncStatus.SUCCESS,
        forSearchForm: payload.searchForm,
        forFilters: payload.filters,
        forInterval: payload.interval,
    };
}
