import {createAsyncAction, createAction} from 'typesafe-actions';

import TValidDataForRequestDynamic from 'types/avia/dynamic/TValidDataForRequestDynamic';

import {
    IDynamicsDay,
    TDynamicsDaysInfo,
} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

const {
    request: weekPricesSearchRequest,
    success: weekPricesSearchSuccess,
    failure: weekPricesSearchFailure,
} = createAsyncAction(
    'avia/aviaPriceIndex/weekPrices/SEARCH_REQUEST',
    'avia/aviaPriceIndex/weekPrices/SEARCH_SUCCESS',
    'avia/aviaPriceIndex/weekPrices/SEARCH_FAILURE',
)<
    TValidDataForRequestDynamic,
    {data: TDynamicsDaysInfo} & TValidDataForRequestDynamic,
    {error: string} & TValidDataForRequestDynamic
>();

const {
    request: inlineSearchRequest,
    success: inlineSearchSuccess,
    failure: inlineSearchFailure,
} = createAsyncAction(
    'avia/aviaPriceIndex/weekPrices/INLINE_SEARCH_REQUEST',
    'avia/aviaPriceIndex/weekPrices/INLINE_SEARCH_SUCCESS',
    'avia/aviaPriceIndex/weekPrices/INLINE_SEARCH_FAILURE',
)<
    TValidDataForRequestDynamic,
    {data: IDynamicsDay} & TValidDataForRequestDynamic,
    {error: string} & TValidDataForRequestDynamic
>();

const inlineSearchPriceFounded = createAction(
    'avia/aviaPriceIndex/weekPrices/INLINE_SEARCH_PRICE_FOUNDED',
)<{data: IDynamicsDay} & TValidDataForRequestDynamic>();

const updatePrices = createAction(
    'avia/aviaPriceIndex/weekPrices/UPDATE_WEEK_PRICES',
)<{data: TDynamicsDaysInfo} & TValidDataForRequestDynamic>();

export {
    updatePrices,
    weekPricesSearchRequest,
    weekPricesSearchSuccess,
    weekPricesSearchFailure,
    inlineSearchRequest,
    inlineSearchSuccess,
    inlineSearchFailure,
    inlineSearchPriceFounded,
};
