import {ActionType, createReducer} from 'typesafe-actions';

import EAsyncStatus from 'types/common/EAsyncStatus';
import TValidSearchForm from 'types/avia/dynamic/TValidSearchForm';

import {TDynamicsDaysInfo} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';
import {IAviaSearchResultsFilters} from 'reducers/avia/search/results/filters/reducer';
import dynamicSearchRequestHandler from 'reducers/avia/aviaPriceIndex/utils/dynamicSearchRequestHandler';
import dynamicSearchSuccessHandler from 'reducers/avia/aviaPriceIndex/utils/dynamicSearchSuccessHandler';
import dynamicSearchFailureHandler from 'reducers/avia/aviaPriceIndex/utils/dynamicSearchFailureHandler';
import dynamicUpdatePrices from 'reducers/avia/aviaPriceIndex/utils/dynamicUpdatePrices';
import dynamicInlineSearchRequestHandler from 'reducers/avia/aviaPriceIndex/utils/dynamicInlineSearchRequestHandler';
import dynamicInlineSearchPriceFoundedHandler from 'reducers/avia/aviaPriceIndex/utils/dynamicInlineSearchPriceFoundedHandler';
import dynamicInlineSearchFailureHandler from 'reducers/avia/aviaPriceIndex/utils/dynamicInlineSearchFailureHandler';

import {TInterval} from 'projects/avia/components/Dynamics/utilities/getAviaDynamicsCalendarDates';

import * as actions from './actions';

export interface IAviaWeekPricesState {
    // Статус запроса к динамике цен
    status: EAsyncStatus | null;
    // Цены
    prices: TDynamicsDaysInfo | null;
    // Ошибка при запросе
    error: string | null;
    // Данные поисковой формы, для которой произведен/производится запрос
    forSearchForm: TValidSearchForm | null;
    // Данные фильтров, для которых произведен/производится запрос
    forFilters: IAviaSearchResultsFilters | null;
    // Интервал дней, для которого произведен/производится запрос
    forInterval: TInterval | null;
}

export default createReducer<IAviaWeekPricesState, ActionType<typeof actions>>({
    status: null,
    prices: null,
    error: null,
    forSearchForm: null,
    forFilters: null,
    forInterval: null,
})
    .handleAction(actions.weekPricesSearchRequest, dynamicSearchRequestHandler)
    .handleAction(actions.weekPricesSearchSuccess, dynamicSearchSuccessHandler)
    .handleAction(actions.weekPricesSearchFailure, dynamicSearchFailureHandler)
    .handleAction(actions.updatePrices, dynamicUpdatePrices)
    .handleAction(
        actions.inlineSearchRequest,
        dynamicInlineSearchRequestHandler,
    )
    .handleAction(
        [actions.inlineSearchSuccess, actions.inlineSearchPriceFounded],
        dynamicInlineSearchPriceFoundedHandler,
    )
    .handleAction(
        actions.inlineSearchFailure,
        dynamicInlineSearchFailureHandler,
    );
