import {ActionType} from 'typesafe-actions';

import * as compositeStateActions from './compositeStates/actions';
import * as orderActions from './orders/actions';
import * as variantActions from './variants/actions';
import * as createOrderActions from './createOrder/actions';
import * as travellerNotebookActions from './travellerNotebook/actions';
import * as tariffsModalIsOpenedActions from './tariffsModalIsOpened/actions';

export type TBookingActionType =
    | ActionType<typeof compositeStateActions>
    | ActionType<typeof orderActions>
    | ActionType<typeof createOrderActions>
    | ActionType<typeof travellerNotebookActions>
    | ActionType<typeof variantActions>
    | ActionType<typeof tariffsModalIsOpenedActions>;

export {
    compositeStateActions,
    orderActions,
    variantActions,
    createOrderActions,
    travellerNotebookActions,
    tariffsModalIsOpenedActions,
};
