import {createAsyncAction, createAction} from 'typesafe-actions';

import {ICompositeOrderStateDTO} from 'server/api/AviaBookingApi/types/ICompositeOrderStateDTO';

type WithOrderId<T = void> = [string, T];

const {
    failure: compositeStateFailure,
    request: requestCompositeState,
    success: setCompositeState,
} = createAsyncAction(
    'avia/booking/compositeState/REQUEST',
    'avia/booking/compositeState/SUCCESS',
    'avia/booking/compositeState/FAILURE',
)<WithOrderId, WithOrderId<ICompositeOrderStateDTO>, WithOrderId<Error>>();

const startStatePolling = createAction(
    'avia/booking/compositeState/START_POLLING',
)<{orderId: string}>();

const stopStatePolling = createAction(
    'avia/booking/compositeState/STOP_POLLING',
)<void>();

export {
    compositeStateFailure,
    requestCompositeState,
    setCompositeState,
    startStatePolling,
    stopStatePolling,
};
