import {ActionType, createReducer} from 'typesafe-actions';

import {ICompositeOrderStateDTO} from 'server/api/AviaBookingApi/types/ICompositeOrderStateDTO';

import * as actions from './actions';

export interface AviaCompositeOrderStatesResource {
    loading: boolean;
    error: Error | null;
    compositeState: ICompositeOrderStateDTO | null;
}

export type AviaCompositeOrderStatesState = Record<
    string,
    AviaCompositeOrderStatesResource
>;

const aviaBookingOrdersReducer = createReducer<
    AviaCompositeOrderStatesState,
    ActionType<typeof actions>
>({})
    .handleAction(actions.requestCompositeState, (state, {payload: [id]}) => ({
        ...state,
        [id]: {loading: true, error: null, compositeState: null},
    }))
    .handleAction(
        actions.setCompositeState,
        (state, {payload: id, meta: compositeState}) => ({
            ...state,
            [id]: {loading: false, error: null, compositeState},
        }),
    )
    .handleAction(
        actions.compositeStateFailure,
        (state, {payload: id, meta: error}) => ({
            ...state,
            [id]: {loading: false, error, compositeState: null},
        }),
    );

export default aviaBookingOrdersReducer;
