import {createAsyncAction, createAction} from 'typesafe-actions';

import {IBookingFormData} from 'projects/avia/pages/AviaBooking/types/IBookingFormData';

const {
    failure: createOrderFailure,
    request: createOrderRequest,
    success: createOrderSuccess,
} = createAsyncAction(
    'avia/booking/order/CREATE_ORDER_REQUEST',
    'avia/booking/order/CREATE_ORDER_SUCCESS',
    'avia/booking/order/CREATE_ORDER_FAILURE',
)<IBookingFormData, {orderId: string}, Error | null>();

const cleanupCreateOrderState = createAction(
    'avia/booking/order/CREATE_ORDER_CLEANUP',
)();

export {
    createOrderRequest,
    createOrderSuccess,
    createOrderFailure,
    cleanupCreateOrderState,
};
