import {createReducer, ActionType} from 'typesafe-actions';

import * as actions from './actions';

export interface AviaCreateOrderState {
    orderId: string | null;
    loading: boolean;
    error: Error | null;
}

export default createReducer<AviaCreateOrderState, ActionType<typeof actions>>({
    orderId: null,
    loading: false,
    error: null,
})
    .handleAction(actions.createOrderRequest, () => ({
        orderId: null,
        loading: true,
        error: null,
    }))
    .handleAction(actions.createOrderSuccess, (_, {payload}) => ({
        orderId: payload.orderId,
        loading: false,
        error: null,
    }))
    .handleAction(actions.createOrderFailure, (_, {payload}) => ({
        orderId: null,
        loading: false,
        error: payload,
    }))
    .handleAction(actions.cleanupCreateOrderState, () => ({
        orderId: null,
        loading: false,
        error: null,
    }));
