import {createAsyncAction, createAction} from 'typesafe-actions';

import {IConfirmationCompleteApiRequest} from 'server/api/AviaBookingApi/types/IConfirmationCompleteApiRequest';

export interface IInitPaymentPayload {
    orderId: string;
    isMobile: boolean;
}

const {
    request: initOrderPayment,
    success: initPaymentSuccess,
    failure: initPaymentFailure,
} = createAsyncAction(
    'avia/booking/initPayment/REQUEST',
    'avia/booking/initPayment/SUCCESS',
    'avia/booking/initPayment/FAILURE',
)<IInitPaymentPayload, void, Error>();

const confirmationComplete = createAction(
    'avia/booking/confirmationComplete',
)<IConfirmationCompleteApiRequest>();

const orderPaymentPollingFailure = createAction(
    'avia/booking/orderPayment/POLLING_FAILURE',
)<void>();

export {
    initOrderPayment,
    initPaymentFailure,
    initPaymentSuccess,
    confirmationComplete,
    orderPaymentPollingFailure,
};
