import {createReducer, ActionType} from 'typesafe-actions';

import * as actions from './actions';

export enum EOrderPaymentStatus {
    Unknown = 'Unknown',
    Failed = 'Failed',
    PollingFailed = 'PollingFailed',
}

export default createReducer<EOrderPaymentStatus, ActionType<typeof actions>>(
    EOrderPaymentStatus.Unknown,
)
    .handleAction(actions.initPaymentFailure, () => EOrderPaymentStatus.Failed)
    .handleAction(
        actions.orderPaymentPollingFailure,
        () => EOrderPaymentStatus.PollingFailed,
    );
