import {createAsyncAction} from 'typesafe-actions';

import {IAviaBookingOrderPageData} from 'server/services/AviaBookingService/order/IAviaBookingOrderPageData';

type WithOrderId<T = undefined> = T extends undefined ? [string] : [string, T];

const {
    failure: orderFailure,
    request: requestOrder,
    success: setOrder,
} = createAsyncAction(
    'avia/booking/order/REQUEST',
    'avia/booking/order/SUCCESS',
    'avia/booking/order/FAILURE',
)<WithOrderId, WithOrderId<IAviaBookingOrderPageData>, WithOrderId<Error>>();

export {orderFailure, requestOrder, setOrder};
