import {ActionType, createReducer} from 'typesafe-actions';

import {IAviaBookingOrderPageData} from 'server/services/AviaBookingService/order/IAviaBookingOrderPageData';

import * as actions from './actions';

export interface AviaBookingOrdersResource {
    loading: boolean;
    error: Error | null;
    order: IAviaBookingOrderPageData | null;
}

export type AviaBookingOrdersState = Record<
    string,
    AviaBookingOrdersResource | undefined
>;

const aviaBookingOrdersReducer = createReducer<
    AviaBookingOrdersState,
    ActionType<typeof actions>
>({})
    .handleAction(actions.requestOrder, (state, {payload: [id]}) => ({
        ...state,
        [id]: {loading: true, error: null, order: null},
    }))
    .handleAction(actions.setOrder, (state, {payload: id, meta: order}) => ({
        ...state,
        [id]: {loading: false, error: null, order},
    }))
    .handleAction(
        actions.orderFailure,
        (state, {payload: id, meta: error}) => ({
            ...state,
            [id]: {loading: false, error, order: null},
        }),
    );

export default aviaBookingOrdersReducer;
