import {combineReducers} from 'redux';
import {StateType} from 'typesafe-actions';

import compositeStates from './compositeStates/reducer';
import orders from './orders/reducer';
import variants from './variants/reducer';
import createOrder from './createOrder/reducer';
import travellerNotebook from './travellerNotebook/reducer';
import orderPayment from './orderPayment/reducer';
import tariffsModalIsOpened from './tariffsModalIsOpened/reducer';

const aviaBookingReducer = combineReducers({
    compositeStates,
    orders,
    variants,
    createOrder,
    travellerNotebook,
    orderPayment,
    tariffsModalIsOpened,
});

export type AviaBookingStateType = StateType<typeof aviaBookingReducer>;

export default aviaBookingReducer;
