import {createReducer, ActionType} from 'typesafe-actions';

import * as actions from './actions';

type TBookingTariffsModalIsOpenedState = boolean;

const initialState: TBookingTariffsModalIsOpenedState = false;

const aviaBookingTariffsModalIsOpenedReducer = createReducer<
    TBookingTariffsModalIsOpenedState,
    ActionType<typeof actions>
>(initialState)
    .handleAction(actions.openTariffsModal, () => true)
    .handleAction(actions.closeTariffsModal, () => false);

export default aviaBookingTariffsModalIsOpenedReducer;
