import {createAsyncAction} from 'typesafe-actions';

import {ITravelerNotebook} from 'projects/avia/pages/AviaBooking/types/ITravelerNotebook';

const {
    failure: travellerNotebookFailure,
    request: travellerNotebookRequest,
    success: travellerNotebookSuccess,
} = createAsyncAction(
    'avia/booking/travelerNotebook/REQUEST',
    'avia/booking/travelerNotebook/SUCCESS',
    'avia/booking/travelerNotebook/FAILURE',
)<void, ITravelerNotebook, Error>();

export {
    travellerNotebookFailure,
    travellerNotebookRequest,
    travellerNotebookSuccess,
};
