import {createReducer, ActionType} from 'typesafe-actions';

import {ITravelerNotebook} from 'projects/avia/pages/AviaBooking/types/ITravelerNotebook';

import * as actions from './actions';

export interface AviaTravellerNotebookState {
    loading: boolean;
    error: Error | null;
    travellerNotebook: ITravelerNotebook | null;
}

export default createReducer<
    AviaTravellerNotebookState,
    ActionType<typeof actions>
>({
    loading: false,
    error: null,
    travellerNotebook: null,
})
    .handleAction(actions.travellerNotebookRequest, () => ({
        loading: true,
        error: null,
        travellerNotebook: null,
    }))
    .handleAction(actions.travellerNotebookSuccess, (_, {payload}) => ({
        loading: false,
        error: null,
        travellerNotebook: payload,
    }))
    .handleAction(actions.travellerNotebookFailure, (_, {payload}) => ({
        loading: false,
        error: payload,
        travellerNotebook: null,
    }));
