import {createAsyncAction} from 'typesafe-actions';

import {IBookingVariantsModelType} from 'server/services/AviaBookingService/variants/types';

enum AviaBookingVariantsActions {
    REQUEST_VARIANT = 'avia/booking/variants/REQUEST_VARIANT',
    SET_VARIANT = 'avia/booking/variants/SET_VARIANT',
    VARIANT_FAILURE = 'avia/booking/variants/VARIANT_FAILURE',
}

type WithVariantToken<T = undefined> = T extends undefined
    ? [string]
    : [string, T];

const {
    failure: variantFailure,
    request: requestVariant,
    success: setVariant,
} = createAsyncAction(
    AviaBookingVariantsActions.REQUEST_VARIANT,
    AviaBookingVariantsActions.SET_VARIANT,
    AviaBookingVariantsActions.VARIANT_FAILURE,
)<
    WithVariantToken,
    WithVariantToken<IBookingVariantsModelType>,
    WithVariantToken<Error>
>();

export {variantFailure, requestVariant, setVariant};
