import {ActionType, createReducer} from 'typesafe-actions';

import {IBookingVariantsModelType} from 'server/services/AviaBookingService/variants/types';

import * as actions from './actions';

export interface AviaBookingVariantsResource {
    loading: boolean;
    error: Error | null;
    variants: IBookingVariantsModelType | null;
}

export type AviaBookingVariantsState = Record<
    string,
    AviaBookingVariantsResource
>;

const aviaBookingVariantsReducer = createReducer<
    AviaBookingVariantsState,
    ActionType<typeof actions>
>({})
    .handleAction(actions.requestVariant, (state, {payload: [token]}) => ({
        ...state,
        [token]: {loading: true, error: null, variants: null},
    }))
    .handleAction(
        actions.setVariant,
        (state, {payload: token, meta: variants}) => ({
            ...state,
            [token]: {loading: false, error: null, variants},
        }),
    )
    .handleAction(
        actions.variantFailure,
        (state, {payload: token, meta: error}) => ({
            ...state,
            [token]: {loading: false, error, variants: null},
        }),
    );

export default aviaBookingVariantsReducer;
