import {batchActions} from 'redux-batched-actions';

import {ESearchFormFieldName} from 'components/SearchForm/types';

import {getAviaSearchFormActions} from 'reducers/avia/utils/fillSearchForm';
import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

export default function fillFormFromContext(): CustomThunkAction<void> {
    return function (dispatch, getState): void {
        const {
            avia: {aviaContext, searchForm},
        } = getState();

        if (
            searchForm[ESearchFormFieldName.FROM].source ===
                ESuggestSource.CROSS_SEARCH ||
            searchForm[ESearchFormFieldName.TO].source ===
                ESuggestSource.CROSS_SEARCH
        ) {
            return;
        }

        dispatch(batchActions(getAviaSearchFormActions(aviaContext)));
    };
}
