import {createReducer} from 'typesafe-actions';

import {
    DEFAULT_ADULTS_COUNT,
    DEFAULT_AVIA_CLASS,
    DEFAULT_INFANTS_COUNT,
    DEFAULT_CHILDREN_COUNT,
} from 'constants/avia';

import {EOneWay} from 'server/services/AviaSearchService/types/IAviaParams';

import {
    TAviaContextActions,
    setAviaContext,
    resetAviaContext,
} from 'reducers/avia/context/actions';
import {IAviaContext} from 'reducers/avia/data-types';

export const AVIA_SEARCH_FORM_INITIAL_STATE: IAviaContext = {
    adult_seats: `${DEFAULT_ADULTS_COUNT}`,
    children_seats: `${DEFAULT_CHILDREN_COUNT}`,
    infant_seats: `${DEFAULT_INFANTS_COUNT}`,
    from: null,
    fromId: '',
    fromName: '',
    klass: DEFAULT_AVIA_CLASS,
    oneway: EOneWay.ROUND_TRIP,
    return_date: '',
    to: null,
    toId: '',
    toName: '',
    when: '',
};

export default createReducer<IAviaContext, TAviaContextActions>(
    AVIA_SEARCH_FORM_INITIAL_STATE,
)
    .handleAction(setAviaContext, (state, {payload}) => {
        const {klass, ...rest} = payload;

        return {
            klass: klass || DEFAULT_AVIA_CLASS,
            ...rest,
        };
    })
    .handleAction(resetAviaContext, () => AVIA_SEARCH_FORM_INITIAL_STATE);
