import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

import {IGetExtendedCountryRestrictionsResponse} from 'server/api/AviaCountryRestrictionsApi/types/TAviaCountryRestrictionsApiResponse';
import {TCountryKey, TSettlementKey, TStationKey} from 'types/PointKey';

const {request, success, failure} = createAsyncAction(
    'avia/countryRestrictions/REQUEST_DATA',
    'avia/countryRestrictions/REQUEST_DATA_SUCCESS',
    'avia/countryRestrictions/REQUEST_DATA_FAILURE',
)<
    void | {
        fromPointKey: TSettlementKey | TStationKey;
        toPointKey: TSettlementKey | TCountryKey;
        countryId: number;
    },
    IGetExtendedCountryRestrictionsResponse,
    unknown
>();

const reset = createAction('avia/countryRestrictions/RESET_DATA')();

export const getCountryRestrictionsActions = {
    request,
    success,
    failure,
    reset,
};

export type TAviaCountryRestrictionsActions = ActionType<
    typeof getCountryRestrictionsActions
>;
