import {createReducer} from 'typesafe-actions';

import ICountryRestrictionsInfo from 'components/CountryRestrictions/types/ICountryRestrictionsInfo';
import EAsyncStatus from 'types/common/EAsyncStatus';

import {
    getCountryRestrictionsActions,
    TAviaCountryRestrictionsActions,
} from 'reducers/avia/countryRestrictions/actions';

const INITIAL_STATE: ICountryRestrictionsInfo = {
    status: null,
    data: null,
    cache: {},
};

export default createReducer<
    ICountryRestrictionsInfo,
    TAviaCountryRestrictionsActions
>(INITIAL_STATE)
    .handleAction(getCountryRestrictionsActions.request, state => ({
        status: EAsyncStatus.LOADING,
        data: null,
        cache: state.cache,
    }))
    .handleAction(getCountryRestrictionsActions.success, (state, {payload}) => {
        const countryId = payload.countryId;
        const cache =
            !countryId || state.cache?.[countryId]
                ? state.cache
                : {...state.cache, [countryId]: payload};

        return {
            status: EAsyncStatus.SUCCESS,
            data: payload,
            cache,
        };
    })
    .handleAction(
        getCountryRestrictionsActions.failure,
        (state, {payload}) => ({
            ...state,
            status:
                // Если информации нет, то покажем спецбаннер
                payload?.response?.status === 404 ? null : EAsyncStatus.ERROR,
            data: null,
        }),
    )
    .handleAction(getCountryRestrictionsActions.reset, state => ({
        ...INITIAL_STATE,
        cache: state.cache,
    }));
