import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';
import {
    IAviaDataByPointKey,
    IAviaPointSettlementData,
} from 'server/services/AviaGeoService/types/IAviaDataByPointKey';
import {IAviaSuggest} from 'types/avia/suggests/IAviaSuggest';

export type RemoteResourceStatus = 'ERROR' | 'FETCHING' | 'READY' | 'INIT';

export interface IAviaContext extends IAviaParams {
    from: Nullable<IAviaSuggest>;
    to: Nullable<IAviaSuggest>;
    fromName: string;
    toName: string;
}

export interface IAviaPointsData {
    from: IAviaDataByPointKey | null;
    to: IAviaDataByPointKey | null;

    fromSettlement?: IAviaPointSettlementData;
    toSettlement?: IAviaPointSettlementData;
}
