import {ActionType, createAsyncAction} from 'typesafe-actions';

import {IAviaFlight} from 'types/avia/flight/IAviaFlight';
import {IAviaGetFlightPageServiceParams} from 'server/services/AviaService/types/IAviaGetFlightPageServiceParams';

export const getFlightActions = createAsyncAction(
    'AVIA.FLIGHT.REQUEST',
    'AVIA.FLIGHT.REQUEST_SUCCESS',
    'AVIA.FLIGHT.REQUEST_FAILURE',
)<IAviaGetFlightPageServiceParams, IAviaFlight, number | undefined>();

export type TAviaFlightActions = ActionType<typeof getFlightActions>;
