import {createReducer} from 'typesafe-actions';

import {TAviaFlightStore} from 'reducers/avia/flight/types';

import {
    getFlightActions,
    TAviaFlightActions,
} from 'reducers/avia/flight/actions';

const INITIAL_STATE: TAviaFlightStore = {
    value: null,
    requestParams: null,
    isLoading: false,
    isFetched: false,
    isFailed: false,
    isNotFound: false,
};

export default createReducer<TAviaFlightStore, TAviaFlightActions>(
    INITIAL_STATE,
)
    .handleAction(getFlightActions.request, (state, {payload}) => ({
        ...state,
        value: null,
        requestParams: payload,
        isLoading: true,
        isFetched: false,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getFlightActions.success, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getFlightActions.failure, (state, {payload}) => ({
        ...state,
        value: null,
        isLoading: false,
        isFetched: true,
        isFailed: true,
        isNotFound: payload === 404,
    }));
