import {ActionType, createAsyncAction} from 'typesafe-actions';

import {IAviaFlightsToResponse} from 'types/avia/landing/flightsTo/IAviaFlightsTo';

export interface IAviaRequestFlightsToDataAction {
    toSlug: string;
}

export const getFlightsToDataActions = createAsyncAction(
    'AVIA.FLIGHTS_TO.REQUEST_DATA',
    'AVIA.FLIGHTS_TO.REQUEST_DATA_SUCCESS',
    'AVIA.FLIGHTS_TO.REQUEST_DATA_FAILURE',
)<IAviaRequestFlightsToDataAction, IAviaFlightsToResponse, number | null>();

export type TAviaFlightsToActions = ActionType<typeof getFlightsToDataActions>;
