import {createReducer} from 'typesafe-actions';

import {IAviaFlightsToResponse} from 'types/avia/landing/flightsTo/IAviaFlightsTo';

import {
    getFlightsToDataActions,
    IAviaRequestFlightsToDataAction,
    TAviaFlightsToActions,
} from 'reducers/avia/flightsTo/actions';

export interface IAviaFlightsToStore {
    isLoading: boolean;
    isFetched: boolean;
    isError: boolean;
    isNotFound: boolean;
    requestParams: IAviaRequestFlightsToDataAction | null;
    data?: IAviaFlightsToResponse;
}

const INITIAL_STATE: IAviaFlightsToStore = {
    isLoading: false,
    isFetched: false,
    isError: false,
    isNotFound: false,
    requestParams: null,
};

export default createReducer<IAviaFlightsToStore, TAviaFlightsToActions>(
    INITIAL_STATE,
)
    .handleAction(getFlightsToDataActions.request, (state, {payload}) => ({
        ...state,
        isLoading: true,
        isFetched: false,
        isError: false,
        isNotFound: false,
        requestParams: payload,
    }))
    .handleAction(getFlightsToDataActions.success, (state, {payload}) => ({
        ...state,
        data: payload,
        isLoading: false,
        isFetched: true,
        isNotFound: false,
        isError: false,
    }))
    .handleAction(getFlightsToDataActions.failure, (state, {payload}) => {
        if (payload === 404) {
            return {
                isLoading: false,
                isFetched: false,
                isNotFound: true,
                isError: true,
                requestParams: null,
            };
        }

        return {
            isLoading: false,
            isFetched: false,
            isNotFound: false,
            isError: true,
            requestParams: null,
        };
    });
