import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getFlightsToDataActions} from 'reducers/avia/flightsTo/actions';

import {getAviaFlightsTo} from 'selectors/avia/aviaSelectors';

import {isUnknownAxiosError} from 'utilities/error';

import {aviaFlightsToProvider} from 'serviceProvider/avia/aviaFlightsToProvider';

interface IFetchFlightsToAction {
    req?: Request;
    toSlug: string;
}

export const requestFlightsToDataThunkAction = ({
    req,
    toSlug,
}: IFetchFlightsToAction): CustomThunkAction<void> => {
    return async (dispatch, getState): Promise<void> => {
        try {
            const {requestParams: prevRequestParams} = getAviaFlightsTo(
                getState(),
            );

            if (prevRequestParams && prevRequestParams.toSlug === toSlug) {
                return;
            }

            dispatch(
                getFlightsToDataActions.request({
                    toSlug,
                }),
            );

            const data = await aviaFlightsToProvider
                .provider(req?.container)
                .getFlightsToData({toSlug});

            dispatch(getFlightsToDataActions.success(data));
        } catch (error) {
            const status = isUnknownAxiosError(error)
                ? error.response?.status
                : undefined;

            dispatch(getFlightsToDataActions.failure(status ?? null));
        }
    };
};
