import {ActionType, createAction} from 'typesafe-actions';

import {
    IAviaTDAnswer,
    IProgress,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {
    INormalizedTDAnswer,
    normalizeTDAnswer,
} from 'reducers/avia/utils/ticketDaemon/normalizeTDAnswer';
import {StoreInterface} from 'reducers/storeTypes';

export interface IAviaOrderBaggageFilterActionMeta {
    // используется для инициализации фильтра багажа при переходе с поиска на покупку,
    // чтобы не вызывать лишних перерендеров и срабатываний обработчиков
    isInitial: boolean;
}

export const aviaOrderActions = {
    setBadPartners: createAction('avia/order/SET_BAD_PARTNERS')<string[]>(),
    setUseOrderData: createAction('avia/order/SET_USE_ORDER_DATA')<boolean>(),
    setVariantKey: createAction('avia/order/SET_VARIANT_KEY')<string>(),
    setSearchQid: createAction('avia/order/SET_ORDER_SEARCH_QID')<
        string | null
    >(),
    setBaggageFilter: createAction(
        'avia/order/SET_BAGGAGE_FILTER',
        (payload: boolean, _meta?: IAviaOrderBaggageFilterActionMeta) =>
            payload,
        (payload: boolean, meta?: IAviaOrderBaggageFilterActionMeta) => meta,
    )(),
    stopDataFetching: createAction('avia/order/STOP_DATA_FETCHING')(),
    setPartnersDataWereFetched: createAction(
        'avia/order/SET_PARTNERS_DATA_WERE_FETCHED',
    )<boolean>(),
    setVariantData: createAction(
        'avia/order/SET_ORDER_VARIANT_DATA',
        (payload: IAviaTDAnswer) => normalizeTDAnswer(payload),
    )(),
    // перегрузка экшена
    setNormalizedVariantData: createAction('avia/order/SET_ORDER_VARIANT_DATA')<
        Partial<INormalizedTDAnswer>
    >(),
    startUpdateVariant: createAction('avia/order/START_UPDATE_VARIANT_DATA')<
        string | null
    >(),
    updateVariant: createAction(
        'avia/order/UPDATE_VARIANT_DATA',
        (payload: IAviaTDAnswer, _meta?: StoreInterface) =>
            normalizeTDAnswer(payload),
        (payload: IAviaTDAnswer, meta?: StoreInterface) => meta,
    )(),
    reset: createAction('avia/order/RESET')(),
    setHasGoodPrice: createAction('avia/order/SET_HAS_GOOD_PRICE')<boolean>(),
    updateVariantFailure: createAction(
        'avia/order/UPDATE_VARIANT_DATA_FAILURE',
    )(),
    initSearch: createAction('avia/order/INIT_SEARCH')(),
    updateProgress: createAction('avia/order/UPDATE_PROGRESS')<IProgress>(),
};

export type TAviaOrderActions = ActionType<typeof aviaOrderActions>;
