/* eslint-disable camelcase */

import {Request} from '@yandex-data-ui/core/lib/types';
import {IAviaGetOrderParams} from 'server/services/AviaOrderService/types/IAviaGetOrderParams';
import {EAviaClassType} from 'types/avia/EAviaClassType';
import {EOneWay} from 'server/services/AviaSearchService/types/IAviaParams';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {aviaOrderActions} from 'reducers/avia/order/actions';

import {aviaVariantsProvider} from 'serviceProvider/avia/aviaVariantsProvider';
import {aviaOrderProvider} from 'serviceProvider/avia/aviaOrderProvider';

export default function requestOrderThunkAction({
    req,
    params,
}: {
    req?: Request;
    params: Omit<IAviaGetOrderParams, 'qid' | 'klass' | 'return_date'> & {
        klass: EAviaClassType;
        oneway: EOneWay;
        return_date: string;
        partner?: string;
        fromError?: string;
    };
}): CustomThunkAction<void> {
    return async (dispatch): Promise<void> => {
        const {partner, fromError} = params;

        if (fromError && partner) {
            dispatch(aviaOrderActions.setBadPartners([partner]));
        }

        dispatch(aviaOrderActions.setUseOrderData(true));

        try {
            let qid: Nullable<string> = null;

            try {
                qid = (
                    await aviaVariantsProvider
                        .provider(req?.container)
                        .initByQuery(params)
                ).id;
            } catch (e) {}

            try {
                const data = await aviaOrderProvider
                    .provider(req?.container)
                    .getOrder({
                        ...params,
                        qid,
                    });

                if (data) {
                    dispatch(aviaOrderActions.setVariantData(data));
                }
            } catch (e) {}

            dispatch(aviaOrderActions.setSearchQid(qid));
            dispatch(aviaOrderActions.setPartnersDataWereFetched(true));
        } catch (e) {}
    };
}
