import {ActionType, createAction} from 'typesafe-actions';

import {EAviaActionLogPageName} from 'server/loggers/avia/AviaActionLog/types/EAviaActionLogPageName';

import {StoreInterface} from 'reducers/storeTypes';

export const setAviaCurrentPage = createAction(
    'AVIA/page/setCurrentPage',
    (payload: EAviaActionLogPageName, _meta?: StoreInterface) => payload,
    (payload: EAviaActionLogPageName, meta?: StoreInterface) => meta,
)();

const pageActions = {
    setAviaCurrentPage,
};

export type TAviaPageActions = ActionType<typeof pageActions>;
