import {createReducer} from 'typesafe-actions';

import {EAviaActionLogPageName} from 'server/loggers/avia/AviaActionLog/types/EAviaActionLogPageName';

import {setAviaCurrentPage, TAviaPageActions} from 'reducers/avia/page/actions';

export interface IAviaPage {
    entryPage: Nullable<EAviaActionLogPageName>;
    currentPage: Nullable<EAviaActionLogPageName>;
}

const INITIAL_STATE: IAviaPage = {
    entryPage: null,
    currentPage: null,
};

export default createReducer<IAviaPage, TAviaPageActions>(
    INITIAL_STATE,
).handleAction(setAviaCurrentPage, (state, {payload}) => ({
    ...state,
    currentPage: payload,
    entryPage: state.entryPage || payload,
}));
