import {createAsyncAction, ActionType, createAction} from 'typesafe-actions';

import IGetAviaSearchHistoryResponse from 'server/api/PersonalizationApi/types/IGetAviaSearchHistoryResponse';

import {IGetAviaSearchHistoryServiceParams} from 'server/services/PersonalizationService/PersonalizationService';

export const getAviaSearchHistoryActions = createAsyncAction(
    'common/aviaPersonalizationSearchHistory/start',
    'common/aviaPersonalizationSearchHistory/success',
    'common/aviaPersonalizationSearchHistory/failed',
)<
    IGetAviaSearchHistoryServiceParams,
    IGetAviaSearchHistoryResponse,
    undefined
>();

export const resetAviaSearchHistoryAction = createAction(
    'common/aviaPersonalizationSearchHistory/reset',
)();

export type TGetAviaSearchHistoryActionsType = ActionType<
    typeof getAviaSearchHistoryActions
>;

export type TResetAviaSearchHistoryActionType = ActionType<
    typeof resetAviaSearchHistoryAction
>;

export type TAviaPersonalizationActionsTypes =
    | TGetAviaSearchHistoryActionsType
    | TResetAviaSearchHistoryActionType;
