import {createReducer} from 'typesafe-actions';

import IPersonalizedAviaItem from 'server/api/PersonalizationApi/types/IPersonalizedAviaItem';
import EAsyncStatus from 'types/common/EAsyncStatus';

import {
    TAviaPersonalizationActionsTypes,
    getAviaSearchHistoryActions,
    resetAviaSearchHistoryAction,
} from './actions';

export interface ISearchHistoryInfo {
    status: EAsyncStatus | null;
    items: IPersonalizedAviaItem[];
}

export interface IAviaPersonalization {
    searchHistory: ISearchHistoryInfo;
}

const initialState: IAviaPersonalization = {
    searchHistory: {
        status: null,
        items: [],
    },
};

/* Reducer */
export default createReducer<
    IAviaPersonalization,
    TAviaPersonalizationActionsTypes
>(initialState)
    .handleAction(getAviaSearchHistoryActions.request, () => ({
        ...initialState,
        searchHistory: {
            ...initialState.searchHistory,
            status: EAsyncStatus.LOADING,
        },
    }))
    .handleAction(
        getAviaSearchHistoryActions.success,
        (state, {payload}): IAviaPersonalization => ({
            ...state,
            searchHistory: {
                status: EAsyncStatus.SUCCESS,
                items: payload.items || [],
            },
        }),
    )
    .handleAction(
        getAviaSearchHistoryActions.failure,
        (): IAviaPersonalization => ({
            ...initialState,
            searchHistory: {
                ...initialState.searchHistory,
                status: EAsyncStatus.ERROR,
            },
        }),
    )
    .handleAction(
        resetAviaSearchHistoryAction,
        (): IAviaPersonalization => initialState,
    );
