import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {IGetAviaSearchHistoryServiceParams} from 'server/services/PersonalizationService/PersonalizationService';

import {personalizationService} from 'serviceProvider';

import {getAviaSearchHistoryActions} from './actions';

export const getAviaSearchHistory = (
    params: IGetAviaSearchHistoryServiceParams = {},
): CustomThunkAction<void> => {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(getAviaSearchHistoryActions.request(params));

            const result = await personalizationService
                .provider()
                .getAviaSearchHistory({});

            dispatch(getAviaSearchHistoryActions.success(result));
        } catch (error) {
            dispatch(getAviaSearchHistoryActions.failure());
        }
    };
};
