import {ActionType, createAction} from 'typesafe-actions';

import {Request} from '@yandex-data-ui/core/lib/types';

export const fetchPlatform = createAction(
    'avia/platform/FETCH_PLATFORM',
)<Request>();

export const fetchTravelApp = createAction(
    'avia/platform/FETCH_TRAVEL_APP',
)<Request>();

export const setFavorite = createAction('avia/platform/SET_FAVORITE')();

export const unsetFavorite = createAction('avia/platform/UNSET_FAVORITE')();

export type TPlatformActionType =
    | ActionType<typeof fetchPlatform>
    | ActionType<typeof fetchTravelApp>
    | ActionType<typeof setFavorite>
    | ActionType<typeof unsetFavorite>;
