import {createReducer} from 'typesafe-actions';

import {ANDROID, IOS, WEB} from 'server/constants/platforms';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import {
    fetchPlatform,
    fetchTravelApp,
    setFavorite,
    TPlatformActionType,
    unsetFavorite,
} from './actions';

export interface IPlatformState {
    isWeb: boolean;
    isIos: boolean;
    isAndroid: boolean;
    isFakeApp: boolean;
    /**
     * Travel App передает отдельный заголовок,
     * чтобы отличаться от Avia App
     */
    isTravelApp: boolean;
    version?: string;
    nativeAppState: INativeAppState;
}

export interface INativeAppState {
    prefferedCurrency: CurrencyType;
    isFavorite: boolean;
}

export const platformInitialState: IPlatformState = {
    isWeb: true,
    isIos: false,
    isAndroid: false,
    isFakeApp: false,
    isTravelApp: false,
    nativeAppState: {
        prefferedCurrency: CurrencyType.RUB,
        isFavorite: false,
    },
};

export default createReducer<IPlatformState, TPlatformActionType>(
    platformInitialState,
)
    .handleAction(fetchPlatform, (state, {payload}) => ({
        ...state,
        isWeb: payload.platform === WEB,
        isIos: payload.platform === IOS,
        isAndroid: payload.platform === ANDROID,
        isFakeApp: Boolean(payload.isFakeApp),
        version: payload.nativeAppVersion,
        ...(payload.nativeAppState && {
            nativeAppState: payload.nativeAppState,
        }),
    }))
    .handleAction(fetchTravelApp, (state, {payload}) => ({
        ...state,
        isTravelApp: payload.isTravelApp,
    }))
    .handleAction(setFavorite, state => ({
        ...state,
        nativeAppState: {
            ...state.nativeAppState,
            isFavorite: true,
        },
    }))
    .handleAction(unsetFavorite, state => ({
        ...state,
        nativeAppState: {
            ...state.nativeAppState,
            isFavorite: false,
        },
    }));
