import {createReducer} from 'typesafe-actions';

import {
    TAviaPointsDataActions,
    setAviaPointsData,
    resetAviaPointsData,
} from 'reducers/avia/pointsData/actions';
import {IAviaPointsData} from 'reducers/avia/data-types';

const INITIAL_STATE: IAviaPointsData = {
    from: null,
    to: null,
};

export default createReducer<IAviaPointsData, TAviaPointsDataActions>(
    INITIAL_STATE,
)
    .handleAction(setAviaPointsData, (state, {payload}) => {
        return {
            ...state,
            ...payload,
        };
    })
    .handleAction(resetAviaPointsData, () => INITIAL_STATE);
