import {createReducer} from 'typesafe-actions';

import {IPartnerInfo} from 'server/api/AviaPartnersApi/AviaPartnersApi';

import {TAviaRedirectActions, aviaRedirectActions} from './actions';

export interface IAviaRedirectPageQuery {
    qid: string;
    partner: string;
}

export interface IAviaRedirectPageData {
    redirectUrl: string | null;
    errorRedirectUrl: string | null;
    qid: string | null;
    partner: IPartnerInfo | null;
}

const INITIAL_STATE: IAviaRedirectPageData = {
    redirectUrl: null,
    errorRedirectUrl: null,
    qid: null,
    partner: null,
};

export default createReducer<IAviaRedirectPageData, TAviaRedirectActions>(
    INITIAL_STATE,
).handleAction(aviaRedirectActions.setRedirectData, (_, {payload}) => ({
    ...payload,
}));
