import {combineReducers} from 'redux';

import {DeriveActionsTypes} from 'src/types/utilities';
import {ELoadableReducer} from 'types/common/ELoadableReducer';

import aviaPlatform from 'reducers/avia/platform/reducer';
import aviaFeaturesFlags from 'reducers/avia/featuresFlags/reducer';
import searchForm from 'reducers/avia/searchForm/reducer';
import * as calendarPricesActions from 'reducers/avia/aviaCalendarPrices/actions';
import * as bookingActions from 'reducers/avia/booking/actions';
import * as searchActions from 'reducers/avia/search/actions';
import * as pointsDataActions from 'reducers/avia/pointsData/actions';
import * as redirectActions from 'reducers/avia/redirect/actions';
import * as priceIndexActions from 'reducers/avia/aviaPriceIndex/actions';
import * as featuresActions from 'reducers/avia/featuresFlags/actions';
import * as aviaLoggingActions from 'reducers/avia/aviaLogging/actions';
import * as aviaLogMetricsActions from 'reducers/avia/aviaLogMetrics/actions';
import * as aviaPlatformActions from 'reducers/avia/platform/actions';
import * as aviaRouteActions from 'reducers/avia/route/actions';
import * as aviaFlightsToActions from 'reducers/avia/flightsTo/actions';
import * as aviaSearchToCountryActions from 'reducers/avia/searchToCountry/actions';
import * as aviaSearchToAnywhereActions from 'reducers/avia/searchToAnywhere/actions';
import * as aviaWeatherForecastActions from 'reducers/avia/weatherForecast/actions';
import loadableReducer from 'reducers/utils/loadableReducers/loadableReducer';
import {IAviaStore} from 'reducers/avia/IAviaStore';

export default combineReducers<IAviaStore>({
    searchForm,
    searchSuggests: loadableReducer(ELoadableReducer.AVIA_SEARCH_SUGGESTS),
    page: loadableReducer(ELoadableReducer.AVIA_PAGE),
    aviaContext: loadableReducer(ELoadableReducer.AVIA_CONTEXT),
    aviaCalendarPrices: loadableReducer(ELoadableReducer.AVIA_CALENDAR_PRICES),
    aviaBooking: loadableReducer(ELoadableReducer.AVIA_BOOKING),
    aviaSearch: loadableReducer(ELoadableReducer.AVIA_SEARCH),
    aviaOrder: loadableReducer(ELoadableReducer.AVIA_ORDER),
    aviaPointsData: loadableReducer(ELoadableReducer.AVIA_POINTS_DATA),
    aviaRedirect: loadableReducer(ELoadableReducer.AVIA_REDIRECT),
    aviaPriceIndex: loadableReducer(ELoadableReducer.AVIA_PRICE_INDEX),
    aviaFeaturesFlags,
    aviaPlatform,
    aviaRoute: loadableReducer(ELoadableReducer.AVIA_ROUTE),
    aviaFlightsTo: loadableReducer(ELoadableReducer.AVIA_FLIGHTS_TO),
    flight: loadableReducer(ELoadableReducer.AVIA_FLIGHT),
    aviaLogMetrics: loadableReducer(ELoadableReducer.AVIA_LOG_METRICS),
    personalization: loadableReducer(ELoadableReducer.AVIA_PERSONALIZATION),
    countryRestrictions: loadableReducer(
        ELoadableReducer.AVIA_COUNTRY_RESTRICTIONS,
    ),
    searchToCountry: loadableReducer(ELoadableReducer.AVIA_SEARCH_TO_COUNTRY),
    searchToAnywhere: loadableReducer(ELoadableReducer.AVIA_SEARCH_TO_ANYWHERE),
    weatherForecast: loadableReducer(ELoadableReducer.AVIA_WEATHER_FORECAST),
});

export type TAviaActions =
    | DeriveActionsTypes<typeof calendarPricesActions>
    | DeriveActionsTypes<typeof bookingActions>
    | DeriveActionsTypes<typeof searchActions>
    | DeriveActionsTypes<typeof pointsDataActions>
    | DeriveActionsTypes<typeof redirectActions>
    | DeriveActionsTypes<typeof priceIndexActions>
    | DeriveActionsTypes<typeof featuresActions>
    | DeriveActionsTypes<typeof aviaLoggingActions>
    | DeriveActionsTypes<typeof aviaPlatformActions>
    | DeriveActionsTypes<typeof aviaRouteActions>
    | DeriveActionsTypes<typeof aviaFlightsToActions>
    | DeriveActionsTypes<typeof aviaLogMetricsActions>
    | DeriveActionsTypes<typeof aviaSearchToCountryActions>
    | DeriveActionsTypes<typeof aviaSearchToAnywhereActions>
    | DeriveActionsTypes<typeof aviaWeatherForecastActions>;
