import {ActionType, createAsyncAction} from 'typesafe-actions';

import {IAviaRouteResponse} from 'types/avia/landing/route/IAviaRoute';

export interface IAviaRequestRouteDataAction {
    fromSlug: string;
    toSlug: string;
}

export const getRouteDataActions = createAsyncAction(
    'AVIA.ROUTE.REQUEST_DATA',
    'AVIA.ROUTE.REQUEST_DATA_SUCCESS',
    'AVIA.ROUTE.REQUEST_DATA_FAILURE',
)<IAviaRequestRouteDataAction, IAviaRouteResponse, number | null>();

export type TAviaRouteActions = ActionType<typeof getRouteDataActions>;
